
#ifndef __PCMIO_H__
#define __PCMIO_H__

#include <glib.h>

#define DEV_KEY "OSS_Device"
#define MONITOR_DEV_KEY "OSS_MonitorDevice"
#define LOG_FRAGS_KEY "OSS_Logfrags"

#define USE_MONITOR_KEY "UseMonitor"

#define DEFAULT_LOG_FRAGS 6
#define LOG_FRAGS_MIN 1
#define LOG_FRAGS_MAX 10

#define DEFAULT_USE_MONITOR FALSE

#define LOGFRAGS_TO_FRAGS(l) (1 << ((int)(floor((l)) - 1)))

char *
pcmio_get_main_dev (void);

char *
pcmio_get_monitor_dev (void);

gboolean
pcmio_get_use_monitor (void);

int
pcmio_get_log_frags (void);


#endif /* __PCMIO_H__ */
